---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Fielddata Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：具体的な権限名の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行59-61（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行69-82（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行70（data:trueフィルタ）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行73-74（fieldsパラメータ処理）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行91-101（テーブルヘッダー定義）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行104-123（buildTable処理）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行108（null判定）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` 行116（ByteSizeValue変換）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` 行68-91（prepareRequest処理）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` 行73-79（buildResponse処理）
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行12（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/fielddata と /_cat/fielddata/{fields} の2つ | E-01 | ○ |
| C-02 | NodesStatsRequest("data:true")でデータノードのみ対象 | E-03 | ○ |
| C-03 | fields未指定時は全フィールド(*)が対象 | E-04 | ○ |
| C-04 | テーブルカラムは id, host, ip, node, field, size の6つ | E-05 | ○ |
| C-05 | host のaliasは h | E-05 | ○ |
| C-06 | size は右寄せ表示 | E-05 | ○ |
| C-07 | field のaliasは f | E-05 | ○ |
| C-08 | sizeはByteSizeValue形式で出力 | E-08 | ○ |
| C-09 | getFields()がnullの場合はスキップ | E-07 | ○ |
| C-10 | ノードごと→フィールドごとのネストループ | E-06 | ○ |
| C-11 | AbstractCatAction.prepareRequest()でhelpパラメータ処理 | E-09 | ○ |
| C-12 | RestTable.buildResponseでformat判定 | E-10 | ○ |
| C-13 | 帳票名は「Fielddata Report」 | E-11 | ○ |
| C-14 | indices(true)を設定 | E-02 | ○ |
| C-15 | アクション名は cat_fielddata_action | E-02 | ○ |
| C-16 | 出力形式はtext/plainまたはJSON/YAML | E-10 | ○ |
| C-17 | ソースファイルは全124行 | E-06 | ○ |
| C-18 | cluster:monitor/nodes/stats権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はOpenSearch Securityプラグインの設定に依存するため、コアソースコードからは直接確認できない
  - 候補：OpenSearch Security plugin documentation / Security plugin source code / REST API permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント定義・カラム定義・処理フロー（ソースコードで直接確認済み）
- 1: セキュリティ権限名（推定値、プラグイン側の設定確認要）

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラム定義がソースコードと一致しているか確認
- [ ] data:trueフィルタの記述が正確か確認
- [ ] セキュリティ権限名をSecurity plugin側で確認
